<?php

namespace App\Http\Controllers;

use App\Models\ClientCategory;
use App\Models\Currency;
use App\Models\DocType;
use App\Models\Person;
use App\Models\personType;
use App\Models\Product;
use App\Models\ProductBrand;
use App\Models\ProductCategory;
use App\Models\unitOfMeasure;
use App\Models\warehouse;
use App\Models\role;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Request;

class CatalogueController extends Controller
{
    public function getDocTypes()
    {
        $data = DocType::all();

        return response()->json($data, 200);
    }

    public function getPersonTypes()
    {
        $data = personType::all();

        return response()->json($data, 200);
    }

    public function getClientsCategory()
    {
        $data = ClientCategory::where('status', '1')->get();

        return response()->json($data, 200);
    }

    public function getCurrencies()
    {
        $data = Currency::all();

        return response()->json($data, 200);
    }

    public function getUnitsOfMeasure()
    {
        $data = unitOfMeasure::all();

        return response()->json($data, 200);
    }

    public function getProductCategories()
    {
        $search = request()->input('search');
        $limit = 20;
        $query = ProductCategory::where('status', '1');

        if ($search) {
            $query->where('name', 'LIKE', '%' . $search . '%');
        }

        $data = $query->take($limit)->get();
        return response()->json($data, 200);
    }

    public function getProductBrands()
    {
        $data = ProductBrand::where('status', '1')->get();

        return response()->json($data, 200);
    }

    public function getClientsByName()
    {
        $clients = Person::whereHas('persontype', function ($query) {
            $query->where('person_types.id', 1);
        })
            ->with('doctype')
            ->where('status', 1)
            ->where('legal_name', 'LIKE', '%' . request()->input('name') . '%')
            ->latest('people.id')
            ->get();

        return $clients;
    }

    public function getProvidersByName()
    {
        $providers = Person::whereHas('persontype', function ($query) {
            $query->where('person_types.id', 2);
        })
            ->with('doctype')
            ->where('status', 1)
            ->where('legal_name', 'LIKE', '%' . request()->input('name') . '%')
            ->latest('people.id')
            ->get();

        return $providers;
    }


    public function getProductsByName()
    {
        $warehouseId = request()->input('warehouse_id');
        $searchValue = request()->input('name');
        return Product::where(function ($query) use ($searchValue) {
                $query->where('name', "LIKE", "%$searchValue%")
                    ->orWhere('code', "LIKE", "%$searchValue%");
            })
            ->whereHas('warehouses', function ($query) use ($warehouseId) {
                $query->where('warehouse_id', $warehouseId);
            })
            ->with(['warehouses' => function ($query) use ($warehouseId) {
                $query->where('warehouse_id', $warehouseId);
            }])
            ->where('type', request()->input('type'))
            ->with('unitOfMeasure')
            ->with('category')
            ->with('prices.details')
            ->where('status', 1)
            ->latest('products.id')
            ->limit(100)
            ->get();
    }

    public function getWarehousesByName()
    {
        $query = warehouse::with('establishment')
            ->where('status', 1)
            ->where('name', 'LIKE', '%' . request()->input('name') . '%');

        if(!request()->input('name')) {
            $query->take(10);
        }

        return $query->get();
    }

    public function getRoles()
    {
        $data = Role::selectRaw('role.*, role.name as description')->get()->map(function ($item) {
                unset($item->name);
                return $item;
            });

        return response()->json($data, 200);
    }

    public function getpeopleRoleByName()
    {
        $clients =Person::join('people_role', 'people.id', '=', 'people_role.people_id')
            ->with('doctype')
            ->where('people_role.role_id', 2)
            ->where('people_role.status', 1)
            ->where('people.status', 1)
            ->where('legal_name', 'LIKE', '%' . request()->input('name') . '%')
            ->select('people.*', 'people_role.id as people_role_id')
            ->latest('people.id')
            ->get();

      return $clients;
    }
}
