<?php

namespace App\Http\Controllers;
use App\Http\Requests\roleRequest;
use App\Models\Product;
use App\Models\role;
use App\Models\Voucher;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Inertia\Inertia;

class CostController extends Controller
{
    public function getRoleByName() {
        $data = role::where('status', '1')->get();

        return response()->json($data, 200);
    }

    /**
     * Display a listing of the resource.
     */
    public function index(Request $request)
    {
        $categoryId = $request->input('id');
        $category = $request->input('category');
        $statusChanged = $request->input('statusChanged');
        $query = Product::where('status', '1')->with('category');
        $page = $request->input('page', 1);
        $limit = $request->input('limit', 5);
        if ($categoryId) {
            $query->whereHas('category', function ($q) use ($categoryId) {
                $q->where('id', $categoryId);
            });
        }

        $products = $query->paginate($limit, ['*'], 'page', $page);

        return Inertia::render('Cost/Index', [
            'products' => $products,
            'category_id' => $categoryId,
            'statusChanged' => $statusChanged,
        ]);
    }


    /**
     * Store a newly created resource in storage.
     */
    public function store(roleRequest $request)
    {
    }

    public function update(Request $request, $id)
    {

        $request->validate([
            'cost' => 'required|numeric',
        ]);


        $product = Product::findOrFail($id);

        $product->cost = $request->input('cost');
        $product->save();

        return response()->json([
            'message' => 'Costo actualizado correctamente',
            'product' => $product
        ]);
    }

    public function updateAll(Request $request)
    {

        $request->validate([
            'products' => 'required|array',
            'products.*.id' => 'required|exists:products,id',
        ]);

        foreach ($request->products as $productData) {
            $product = Product::findOrFail($productData['id']);
            $product->cost = $productData['cost'];
            $product->save();
        }

        return response()->json([
            'message' => 'Todos los costos han sido actualizados correctamente.'
        ]);
    }

    /**
     * Display the specified resource.
     */
    public function show(role $role)
    {
        return $role;
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(role $role)
    {
        $role->status = '1';
        $role->save();
        $role->delete();
        return redirect('role');
    }

}
