<?php

namespace App\Http\Controllers;

use App\Models\Inventory;
use App\Models\InventoryDetail;
use App\Models\Kardex;
use App\Models\WarehouseDetail;
use Dflydev\DotAccessData\Data;
use Illuminate\Http\Request;
use Inertia\Inertia;

class InventoryDetailController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $query = Inventory::select(['inventory.*', 'warehouse.name as warehouse_name'])
            ->join('warehouse', 'inventory.warehouse_id', '=', 'warehouse.id')
            ->latest('inventory.id');

        if (request()->input('name')) {
            $query->where('inventory.name', 'LIKE', '%' . request()->input('name') . '%');
        }

        if (request()->input('warehouse_name')) {
            $query->where('warehouse.name', 'LIKE', '%' . request()->input('warehouse_name') . '%');
        }

        $inventory = $query->paginate(7)->withQueryString();

        return Inertia::render('inventory/Index', [
            'inventory' => $inventory
        ]);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $productId= $request->input('product_id');
        $inventoryId= $request->input('inventory_id');
        $warehouseId= $request->input('warehouse_id');
        $amount= $request->input('amount');

        $existingDetail = InventoryDetail::where('inventory_id', $inventoryId)
            ->where('product_id', $productId)
            ->first();

       if ($existingDetail) {
            $existingDetail->status = 0;
            $existingDetail->save();
            $existingDetail->delete();
        }

        $newInventoryDetail = new InventoryDetail([
            'inventory_id' => $inventoryId,
            'product_id' => $productId,
            'cost' => 0,
            'amount' => $amount,
            'status_approve' => 0,
            'status' => 1,
        ]);
        $newInventoryDetail->save();
        return redirect('inventory');

    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        $query = InventoryDetail::
        where('inventory_id', $id)
            ->where('status', '1')
            ->whereHas('product', function ($query) {
                $query->where('type', 'product');
            })
            ->with('product')
            ->latest('id');
        $inventoryDetails = $query->paginate(7)->withQueryString();

        return $inventoryDetails;
    }

    public function update(Request $request)
    {

        $inventoryDetailId = $request->input('id');
        $warehouseId = $request->input('warehouse_id');
        $productId = $request->input('product_id');
        $existingDetail = InventoryDetail::where('id', $inventoryDetailId)
            ->first();
        if ($existingDetail) {
            $existingDetail->status_approve = 1;
            $existingDetail->save();
        }
        $amount = $existingDetail->amount;
        $inventoryId = $existingDetail->inventory_id;
       $warehouse_detail = WarehouseDetail::where('product_id', $productId)->where('warehouse_id',$warehouseId)->first();
         if ($warehouse_detail) {
             $warehouse_detail->stock = $amount;
             $warehouse_detail->save();

             $existingKardexs = Kardex::where('warehouse_detail_id', $warehouse_detail->id)->get();
             if (count($existingKardexs)> 0) {
                 foreach ($existingKardexs as $existingKardex) {
                     $existingKardex->status = 0;
                     $existingKardex->save();
                     $existingKardex->delete();
                 }
             }

             $type = 'entry';
             if($inventoryId == 1){
                 $type = 'initial_entry';
             }

             $kardex = new Kardex(['warehouse_detail_id' => $warehouse_detail->id,
                 'type' => $type,
                 'cost' => 0,
                 'price' => 0,
                 'quantity' => $amount]);
             $kardex->save();
         }

        return response()->json(['message' => 'Datos actualizados correctamente.'], 200);
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Inventory $inventory)
    {
        $inventory->status = '1';
        $inventory->save();
        $inventory->delete();
        return redirect('inventory');
    }
}
