<?php

namespace App\Http\Controllers;

use App\Models\Product;
use App\Models\Kardex;
use Inertia\Inertia;

class KardexController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $id = request()->input('id');


        if ($id != null) {

            $query = ['id' => $id];
        } else {

            $query = [];
        }
        $query = Product::where('status', '1')
            ->where($query)
            ->with('unitOfMeasure')
            ->with('warehouses')
            ->with('kardex')
            ->with('category')
            ->latest('products.id');
        $products = $query->paginate(10)->withQueryString();
        return Inertia::render('Kardex/Index', [
            'products' => $products
        ]);
    }

    public function getKardex()
    {
        $id = request()->input('id');
        $query = [];
        if ($id != null) {
            $query = ['id' => $id];
        }

        $kardex  = Kardex::with('warehouseDetail')  // Cargar la relación
        ->whereHas('warehouseDetail', function ($query) use ($id) {
            $query->where('product_id', $id);  // Filtrar por product_id
        })->leftJoin('vouchers', 'vouchers.id', '=', 'kardex.voucher_id')
        ->leftJoin('people', 'vouchers.person_id', '=', 'people.id')
        ->select('kardex.*', 'vouchers.number as voucher_number', 'people.legal_name')
        ->get();
       return response()->json($kardex);
    }

}
