<?php

namespace App\Http\Controllers;

use App\Http\Requests\ProductRequest;
use App\Models\Inventory;
use App\Models\InventoryDetail;
use App\Models\Kardex;
use App\Models\Price;
use App\Models\PriceDetail;
use App\Models\Product;
use App\Models\ProductBrandDetail;
use App\Models\ProductCategory;
use App\Models\ProductCategoryPercentage;
use App\Models\ProductCategoryPercentageDetail;
use App\Models\warehouse;
use App\Models\WarehouseDetail;
use Inertia\Inertia;

class ProductController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $query = Product::where('status', '1')
            ->with('unitOfMeasure')
            ->with('warehouses')
            ->with('category')
            ->latest('products.id');

        if (request()->input('code')) {
            $query->where('code', 'LIKE', '%' . request()->input('code') . '%');
        }

        if (request()->input('name')) {
            $query->where('name', 'LIKE', '%' . request()->input('name') . '%');
        }

        if (request()->input('unit_of_measure')) {
            $query->whereHas('unitOfMeasure', function ($q) {
                $q->where("description", "LIKE", "%" . request()->input('unit_of_measure') . "%");
            });
        }

        $query->whereHas('category', function ($q) {
            $q->where("name", "LIKE", "%" . request()->input('category') . "%");
            $q->where('status', '1');
        });

        $products = $query->paginate(10)->withQueryString();

        return Inertia::render('Products/Index', [
            'products' => $products
        ]);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(ProductRequest $request)
    {
        \DB::transaction(function () use ($request) {
            if ($request->input('method') === "POST") {

               /* $product_category = new ProductCategory(['name' =>$request->input('nameCategory'),'description' =>'']);
                $product_category->status = 1;
                $product_category->save();

                foreach ($request->input('percentages') as $percentage_key => $value_key) {
                    $percentage = new ProductCategoryPercentage(['product_category_id' => $product_category->id, 'client_category_id' => $percentage_key]);
                    $percentage->status = 1;
                    $percentage->save();

                    foreach ($value_key as $percentage_detail_key => $value_percentage_detail) {
                        $percentage_detail = new ProductCategoryPercentageDetail(['percentage_id' => $percentage->id, 'currency_id' => $percentage_detail_key, 'percentage' => $value_percentage_detail]);
                        $percentage_detail->status = 1;
                        $percentage_detail->save();
                    }
                }*/

                $product = new Product($request->input());
             //   $product->category_id = $product_category->id;
                $product->status = 1;
                $product->save();

               $percentages = $product->category->percentages_relation;

                foreach ($percentages as $percentage) {
                    $price = new Price(['product_id' => $product->id, 'client_category_id' => $percentage->client_category_id]);
                    $price->status = 1;
                    $price->save();

                    foreach ($percentage->details as $percentageDetail) {
                        $priceDetail = new PriceDetail(['price_id' => $price->id, 'currency_id' => $percentageDetail->pivot->currency_id, 'amount' => $percentageDetail->pivot->percentage ? ($product->cost * (1 + $percentageDetail->pivot->percentage/100)) : null]);
                        $priceDetail->status = 1;
                        $priceDetail->save();
                    }
                }

                if ($request->input('warehouses_detail') && $product) {
                    foreach ($request->input('warehouses_detail') as $value) {
                        $warehouse_detail = new WarehouseDetail(['product_id' => $product->id, 'warehouse_id' => $value['warehouse_id'], 'stock' => $value['initial_stock']]);
                        $warehouse_detail->save();

                        $kardex = new Kardex([
                            'warehouse_detail_id' => $warehouse_detail->id,
                            'type' => 'initial_entry',
                            'cost' => $product->cost,
                            'quantity' => $value['initial_stock'],
                        ]);
                        $kardex->save();

                        $inventory = Inventory::where('warehouse_id', $value['warehouse_id'])
                            ->orderBy('created_at', 'asc')
                            ->first();

                        if (!$inventory) {
                            $inventory = new Inventory(['name' => warehouse::find($value['warehouse_id'])->name, 'description' => 'Initial inventory', 'status' => 1, 'warehouse_id' => $value['warehouse_id']]);
                            $inventory->save();
                        }

                        $inventory_detail = new InventoryDetail(['inventory_id' => $inventory->id, 'product_id' => $product->id, 'amount' => $value['initial_stock'], 'status' => 1]);
                        $inventory_detail->save();
                    }
                }


            } else {
    /*            $products_category = ProductCategory::find($request->input("category_id"));
                $products_category->update(['name' => $request->input('nameCategory')]);

                $existingCurrencies = ProductCategoryPercentageDetail::whereIn('percentage_id', $products_category->percentages_relation->pluck('id'))->pluck('currency_id')->toArray();

                foreach ($request->input('percentages') as $percentage_key => $value_key) {
                    $percentage = $products_category->percentages_relation()->updateOrCreate(
                        ['client_category_id' => $percentage_key],
                        ['status' => 1]
                    );

                    foreach ($value_key as $percentage_detail_key => $value_percentage_detail) {
                        if (!in_array($percentage_detail_key, $existingCurrencies)) {
                            $percentage_detail = new ProductCategoryPercentageDetail(['percentage_id' => $percentage->id, 'currency_id' => $percentage_detail_key, 'percentage' => $value_percentage_detail]);
                            $percentage_detail->status = 1;
                            $percentage_detail->save();
                        } else {
                            $existingPercentageDetail = ProductCategoryPercentageDetail::where('percentage_id', $percentage->id)->where('currency_id', $percentage_detail_key)->first();
                            if ($existingPercentageDetail) {
                                $existingPercentageDetail->update(['percentage' => $value_percentage_detail]);
                            } else {
                                $percentage_detail = new ProductCategoryPercentageDetail(['percentage_id' => $percentage->id, 'currency_id' => $percentage_detail_key, 'percentage' => $value_percentage_detail]);
                                $percentage_detail->status = 1;
                                $percentage_detail->save();
                            }
                        }
                    }
                }*/


                $product = Product::find($request->input("id"));
                if($request->input('category_id') != $product->category_id) {
                    $product->prices()->update(['status'=> '0']);
                    $product->prices()->delete();
                }
                $product->update($request->input());
                $product->brands()->detach();

                $percentages = $product->category->percentages_relation;

                foreach ($percentages as $percentage) {
                    $price = Price::where('product_id', $product->id)->where('client_category_id', $percentage->client_category_id)->first();

                    if(!$price) {
                        $price = new Price(['product_id' => $product->id, 'status' => 1, 'client_category_id' => $percentage->client_category_id]);
                        $price->save();
                    }

                    foreach ($percentage->details as $percentageDetail) {
                        $priceDetail = PriceDetail::where('price_id', $price->id)->where('currency_id', $percentageDetail->pivot->currency_id)->first();
                        if(!$priceDetail) {
                            $priceDetail = new PriceDetail(['price_id' => $price->id, 'status' => 1, 'currency_id' => $percentageDetail->pivot->currency_id, 'amount' => $percentageDetail->pivot->percentage ? ($product->cost * (1 + $percentageDetail->pivot->percentage/100)) : null]);
                        } else {
                            $priceDetail->amount = $percentageDetail->pivot->percentage ? ($product->cost * (1 + $percentageDetail->pivot->percentage/100)) : null;
                        }
                        $priceDetail->save();
                    }
                }
            }

            if ($request->input('brands') && $product) {
                foreach ($request->input('brands') as $value) {
                    $product_brand_detail = new ProductBrandDetail(['product_id' => $product->id, 'product_brand_id' => $value]);
                    $product_brand_detail->save();
                }
            }

            if ($request->file('images') && $product) {
                foreach ($request->file('images') as $image) {
                    $imageName = time() . '_' . $image->getClientOriginalName();
                    $image->storeAs('public/products', $imageName);

                    $product->image = $imageName;
                    $product->save();
                }
            }
        });

        return redirect('products');
    }

    /**
     * Display the specified resource.
     */
    public function show(Product $product)
    {
        $product->load('unitOfMeasure');
        $product->load('warehouses');
        $product->load('category');
        $product->load('brands');

        return $product;
    }

    /**
     * Update the specified resource in storage.
     * This functions not works when you send formData(images), it's a problem of PHP
     */
    public function update(ProductRequest $request, Product $product)
    {
        \DB::transaction(function () use ($request, $product) {
            $product->update($request->input());

            if ($request->file('images')) {
                foreach ($request->file('images') as $image) {
                    $imageName = time() . '_' . $image->getClientOriginalName();
                    $image->storeAs('public/products', $imageName);

                    $product->image = $imageName;
                    $product->save();
                }
            }
        });

        return redirect('products');
    }

    /**
     * Remove the specified resource from storage.
     */

    public function destroy(Product $product)
    {
        $product->status = 0;
        $product->save();
        $product->delete();
        return redirect('products');
    }
}
