<?php

namespace App\Http\Controllers;

use App\Models\StatementOfAccount;
use App\Models\TransactionDetail;
use App\Models\Transactions;
use Illuminate\Http\Request;
use Inertia\Inertia;

class TransactionsController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $query = Transactions::where('status', '1')
            ->whereHas('statementOfAccount', function ($query) {
                $query->where('type_transaction', request()->input('type_transaction'));
            })
            ->with('statementOfAccount.person')
            ->latest('id');
        $transactions = $query->paginate(10)->withQueryString();
        dd($transactions->toArray());
 /*     return Inertia::render('Transactions/Index', [
            'transactions' => $transactions,
            'type_transaction' => request()->input('type_transaction')
        ]);*/
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     */
    public function show(Transactions $transactions)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Transactions $transactions)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, Transactions $transactions)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Transactions $transaction)
    {
        $transaction->load('transaction_details');
        $transaction->transaction_details()->update(['status' => 0]);
        $transaction->transaction_details()->delete();
        $transaction->status = 0;
        $transaction->save();
        $transaction->delete();

        foreach ($transaction->transaction_details as $detail) {
            $detail->statementOfAccount()->update(['payment_status' => 0]);
        }

    }

    public function showByPerson(Request $request, $person_id)
    {
        $query = Transactions::where('status', 1)
            ->with('person', 'transaction_details','transaction_details.statementOfAccount.voucher','transaction_details.statementOfAccount.person')
            ->where('person_id', $person_id)
            ->where('type_transaction', $request->input('type_transaction'))
            ->latest('id');

        $transactions = $query->paginate(10)->withQueryString();
        if (!$transactions) {
            return response()->json(['message' => 'Statement of Account not found'], 404);
        }
        return response()->json($transactions);
    }

}
