<?php

namespace App\Http\Controllers;
use App\Models\Product;
use Inertia\Inertia;

class WarehouseDetailController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $query = Product::where('status', '1')
            ->with('unitOfMeasure')
            ->with('warehouses')
            ->with('category')
            ->latest('products.id');

        if (request()->input('code')) {
            $query->where('code', 'LIKE', '%' . request()->input('code') . '%');
        }

        if (request()->input('name')) {
            $query->where('name', 'LIKE', '%' . request()->input('name') . '%');
        }

        if (request()->input('unit_of_measure')) {
            $query->whereHas('unitOfMeasure', function ($q) {
                $q->where("description", "LIKE", "%" . request()->input('unit_of_measure') . "%");
            });
        }

        $query->whereHas('category', function ($q) {
            $q->where("name", "LIKE", "%" . request()->input('category') . "%");
            $q->where('status', '1');
        });

        $products = $query->paginate(10)->withQueryString();

        return Inertia::render('WarehouseDetail/Index', [
            'products' => $products
        ]);
    }

}
