<?php

namespace App\Http\Controllers;

use App\Http\Requests\inventoryRequest;
use App\Models\Inventory;
use Illuminate\Http\Request;
use Inertia\Inertia;

class inventoryController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $query = Inventory::select(['inventory.*', 'warehouse.name as warehouse_name'])
            ->join('warehouse', 'inventory.warehouse_id', '=', 'warehouse.id')
            ->latest('inventory.id');

        if (request()->input('name')) {
            $query->where('inventory.name', 'LIKE', '%' . request()->input('name') . '%');
        }

        if (request()->input('warehouse_name')) {
            $query->where('warehouse.name', 'LIKE', '%' . request()->input('warehouse_name') . '%');
        }

        $inventory = $query->paginate(10)->withQueryString();

        return Inertia::render('inventory/Index', [
            'inventory' => $inventory
        ]);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(inventoryRequest $request)
    {
        $data = new Inventory($request->input());
        $data->save();
        return redirect('inventory');
    }

    /**
     * Display the specified resource.
     */
    public function show(Inventory $inventory)
    {
        return $inventory;
    }

    public function update(Request $request, Inventory $inventory)
    {
        $inventory->update($request->input());
        return redirect('inventory');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Inventory $inventory)
    {
        $inventory->status = '1';
        $inventory->save();
        $inventory->delete();
        return redirect('inventory');
    }
}
