<?php

namespace App\Http\Controllers;
use App\Http\Requests\roleRequest;
use App\Models\role;
use Illuminate\Http\Request;
use Inertia\Inertia;

class roleController extends Controller
{
    public function getRoleByName() {
        $data = role::where('status', '1')->get();

        return response()->json($data, 200);
    }

    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $query = role::select(['role.*'])
            ->latest('role.id');

        if (request()->input('name')) {
            $query->where('role.name', 'LIKE', '%' . request()->input('name') . '%');
        }

        if (request()->input('description')) {
            $query->where('role.description', 'LIKE', '%' . request()->input('description') . '%');
        }

        $role = $query->paginate(10)->withQueryString();

        return Inertia::render('role/Index', [
            'role' => $role
        ]);
    }


    /**
     * Store a newly created resource in storage.
     */
    public function store(roleRequest $request)
    {
        $data = new role($request->input());
        $data->save();
        return redirect('role');
    }

    public function update(Request $request, role $role)
    {
        $role->update($request->input());
        return redirect('role');
    }

    /**
     * Display the specified resource.
     */
    public function show(role $role)
    {
        return $role;
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(role $role)
    {
        $role->status = '1';
        $role->save();
        $role->delete();
        return redirect('role');
    }

}
