<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class VoucherRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function rules(): array
    {
        $rules = [];

        $rules['person_id'] = 'required';
        $rules['warehouse_id'] = 'required';
        $rules['details'] = 'required';

        return $rules;
    }

    public function messages()
    {
        $messages = [];
        $messages['person_id.required'] = 'El '. ($this->type_transaction === 'sales' ? 'cliente' : 'proveedor') .' es requerido.';
        $messages['warehouse_id.required'] = 'El almacén es requerido.';
        $messages['details.required'] = 'Debe agregar productos a la cotización.';

        return $messages;
    }
}
