<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class CreditLine extends Model
{
    use HasFactory, SoftDeletes;
    protected $table = "credit_line";
    protected $fillable = ['person_id','total','used','residue','status'];
    protected $keyType = 'string';

    public function department()
    {
        return $this->belongsTo(Department::class);
    }

    public function province()
    {
        return $this->belongsTo(Province::class);
    }

    public function district()
    {
        return $this->belongsTo(District::class);
    }

}
