<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Debt extends Model
{
    use HasFactory;

    public $timestamps = false;

    protected $fillable = [
        'date',
        'voucher_id',
        'status',
        'total_amount',
        'pending_amount'
    ];

    public function setTotalAmountAttribute($value)
    {
        $this->attributes['total_amount'] = round($value, 2);
    }

    public function setPendingAmountAttribute($value)
    {
        $this->attributes['pending_amount'] = round($value, 2);
    }

    public function voucher(): BelongsTo
    {
        return $this->belongsTo(Voucher::class);
    }
}
