<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class InventoryDetail extends Model
{
    use HasFactory, SoftDeletes;

    protected $table = "inventory_detail";

    protected $fillable = ['inventory_id', 'status_approve', 'product_id', 'cost','amount', 'creation_user', 'modification_user', 'elimination_user', 'status'];

    public function product()
    {
        return $this->belongsTo(Product::class, 'product_id');
    }
}
