<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\SoftDeletes;

class Kardex extends Model
{
    use HasFactory, SoftDeletes;

    protected $table = 'kardex';

    protected $fillable = ['warehouse_detail_id','voucher_id','type','cost', 'price', 'quantity','created_at', 'status'];

    protected $dates = ['deleted_at'];

    public function setCostAttribute($value)
    {
        $this->attributes['cost'] = round($value, 2);
    }

    public function setPriceAttribute($value)
    {
        $this->attributes['price'] = round($value, 2);
    }

    public function warehouseDetail()
    {
        return $this->belongsTo(WarehouseDetail::class, 'warehouse_detail_id', 'id');
    }

    public function vouchers()
    {
        return $this->belongsTo(Voucher::class, 'voucher_id', 'id');
    }
}
