<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\SoftDeletes;

class Person extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = ['doc_types', 'document_number','date_of_birth', 'legal_name', 'direction',
        'alias', 'gender', 'email', 'location', 'ubigeo', 'rating', 'credit_line', 'client_category_id'];

    protected $dates = ['deleted_at'];

    public function doctype(): BelongsTo
    {
        return $this->belongsTo(DocType::class, 'doc_types', 'id');
    }

    public function persontype()
    {
        return $this->belongsToMany(personType::class, 'person_type_detail', 'person_id', 'person_type_id');
    }

    public function personPhones()
    {
        return $this->hasMany(PersonPhone::class, 'person_id');
    }

    public function people_role()
    {
        return $this->hasMany(peopleRole::class, 'people_id');
    }


    public function district()
    {
        return $this->belongsTo(District::class, 'ubigeo', 'id');
    }
}
