<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class PersonPhone extends Model
{
    use HasFactory, SoftDeletes;
    protected $table = "person_phone";
    protected $fillable = ['person_id','phone'];
    protected $keyType = 'string';


    public function person()
    {
        return $this->belongsTo(Person::class, 'person_id');
    }

}
