<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Price extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = ['product_id', 'client_category_id', 'creation_user', 'modification_user', 'elimination_user', 'status'];

    public function product()
    {
        return $this->belongsTo(Product::class);
    }

    public function details()
    {
        return $this->belongsToMany(Currency::class, 'price_detail', 'price_id', 'currency_id')->withPivot(["amount"]);
    }
}
