<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class PriceDetail extends Model
{
    use HasFactory, SoftDeletes;

    protected $table = "price_detail";

    protected $fillable = ['price_id', 'currency_id', 'amount', 'creation_user', 'modification_user', 'elimination_user', 'status'];

    public function setAmountAttribute($value)
    {
        $this->attributes['amount'] = round($value, 2);
    }
}
