<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ProductCategory extends Model
{
    use HasFactory, SoftDeletes;

    protected $table = "products_category";

    protected $fillable = ['name','description'];

    protected $dates = ['deleted_at'];

    protected $appends = ['percentages'];

    protected function getPercentagesAttribute() {
        $percentages = [];

        $currencies = Currency::pluck('id')->toArray();

        foreach ($this->percentages_relation as $percentage) {
            $percentageDetails = [];

            // Collect existing currencies associated with price details
            $existingCurrencies = $percentage->details->pluck('pivot.currency_id')->toArray();

            // Get all currencies
            $allCurrencies = Currency::pluck('id')->toArray();

            // Merge existing currencies with all currencies and assign null if not existing
            $allCurrencies = array_merge($allCurrencies, $existingCurrencies);
            $allCurrencies = array_unique($allCurrencies);

            // Fetch percentages for each currency, assigning null if not found
            foreach ($allCurrencies as $currencyId) {
                $percentageDetail = $percentage->details->where('pivot.currency_id', $currencyId)->first();
                $percentageDetails[$currencyId] = $percentageDetail ? $percentageDetail->pivot->percentage : null;
            }

            $percentages[$percentage->client_category_id] = $percentageDetails;
        }

        $clientCategories = ClientCategory::pluck('id')->toArray();

        // Add null values for client categories and currencies that don't have associated percentages
        foreach ($clientCategories as $clientCategoryId) {
            if (!isset($percentages[$clientCategoryId])) {
                $percentages[$clientCategoryId] = array_fill_keys($currencies, null);
            }
        }

        return $percentages;
    }

    public function percentages_relation() {
        return $this->hasMany(ProductCategoryPercentage::class, 'product_category_id', 'id');
    }
}
