<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ProductCategoryPercentage extends Model
{
    use HasFactory, SoftDeletes;

    protected $table="products_category_percentage";

    protected $fillable = ['product_category_id', 'client_category_id', 'creation_user', 'modification_user', 'elimination_user', 'status'];

    public function details()
    {
        return $this->belongsToMany(Currency::class, 'product_category_percentage_detail', 'percentage_id', 'currency_id')->withPivot(["percentage"]);
    }
}
