<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Quota extends Model
{
    use HasFactory;

    public $timestamps = false;

    protected $fillable = ['amount', 'date', 'type_document', 'document_id'];

    public function setAmountAttribute($value)
    {
        $this->attributes['amount'] = round($value, 2);
    }
}
