<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\SoftDeletes;

class StatementOfAccount extends Model
{
    use HasFactory, SoftDeletes;
    protected $table="statement_of_accounts";

    protected $fillable = ['person_id','voucher_id', 'type_transaction','total','issue_date','payment_status', 'status'];

    protected $dates = ['deleted_at'];

    public function person(): BelongsTo
    {
        return $this->belongsTo(Person::class);
    }


    public function transactions()
    {
        return $this->hasMany(Transactions::class, 'statement_of_account_id', 'id');
    }

    public function transaction_details()
    {
        return $this->hasMany(TransactionDetail::class, 'statement_of_account_id', 'id');
    }

    public function voucher(): BelongsTo
    {
        return $this->belongsTo(Voucher::class);
    }

}
