<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\SoftDeletes;


class TransactionDetail extends Model
{
    use HasFactory, SoftDeletes;
    protected $table="transaction_details";
    protected $fillable = ['statement_of_account_id','transaction_id','type_transaction','total','description', 'descriptionAutomatic','issue_date','status'];

    protected $dates = ['deleted_at'];

    public function transactions(): BelongsTo
    {
        return $this->belongsTo(Transactions::class);
    }

    public function transaction()
    {
        return $this->belongsTo(Transactions::class, 'transaction_id', 'id');
    }


    public function StatementOfAccount(): BelongsTo
    {
        return $this->belongsTo(StatementOfAccount::class);
    }


}
