<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\SoftDeletes;

class Transactions extends Model
{
    use HasFactory, SoftDeletes;
    protected $table="transactions";
    protected $fillable = ['person_id','currency_id','type_transaction','total','description', 'descriptionAutomatic','issue_date','status'];
    protected $dates = ['deleted_at'];

    public function StatementOfAccount(): BelongsTo
    {
        return $this->belongsTo(StatementOfAccount::class);
    }

    public function person(): BelongsTo
    {
        return $this->belongsTo(Person::class);
    }

    public function transaction_details()
    {
        return $this->hasMany(TransactionDetail::class, 'transaction_id');
    }

}
