<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\SoftDeletes;

class VoucherDetail extends Model
{
    use HasFactory, SoftDeletes;

    protected $table = "voucher_detail";

    protected $fillable = [
        'voucher_id',
        'type',
        'product_id',
        'cost',
        'priceWithoutTax',
        'priceWithTax',
        'subtotal',
        'total',
        'quantity',
        'igv',
        'unit_of_measure_id',
        'creation_user',
        'modification_user',
        'elimination_user',
        'status'
    ];

    public function setPriceWithoutTaxAttribute($value)
    {
        $this->attributes['priceWithoutTax'] = round($value, 2);
    }

    public function setPriceWithTaxAttribute($value)
    {
        $this->attributes['priceWithTax'] = round($value, 2);
    }

    public function setSubtotalAttribute($value)
    {
        $this->attributes['subtotal'] = round($value, 2);
    }

    public function setTotalAttribute($value)
    {
        $this->attributes['total'] = round($value, 2);
    }

    public function product(): BelongsTo
    {
        return $this->belongsTo(Product::class);
    }
}
