<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\SoftDeletes;

class warehouse extends Model
{
    use HasFactory, SoftDeletes;

    protected $table = "warehouse";
    protected $fillable = ['name','establishment_id','ubigeo', 'description', 'creation_user', 'modification_user', 'elimination_user', 'status'];
    protected $dates = ['deleted_at'];
    public function establishment(): BelongsTo
    {
        return $this->belongsTo(establishment::class);
    }

   protected $keyType = 'string';

    public function district()
    {
        return $this->belongsTo(District::class, 'ubigeo', 'id');
    }

}
