<?php

use App\Helpers\defaultColumnsHelper;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('vouchers', function (Blueprint $table) {
            $table->id();
            $table->string('number');
            $table->unsignedBigInteger('currency_id');
            $table->unsignedBigInteger('budget_id')->nullable();
            $table->foreign('budget_id')->references('id')->on('budgets');
            $table->foreign('currency_id')->references('id')->on('currencies');
            $table->date('issue_date');
            $table->unsignedBigInteger('person_id')->comment('client or provider');
            $table->foreign('person_id')->references('id')->on('people');
            $table->unsignedBigInteger('people_role_id')->comment('employee');
            $table->foreign('people_role_id')->references('id')->on('people_role');
            $table->unsignedBigInteger('warehouse_id');
            $table->foreign('warehouse_id')->references('id')->on('warehouse');
            $table->unsignedBigInteger('voucher_type_id');
            $table->foreign('voucher_type_id')->references('id')->on('voucher_types');
            $table->double('discounts')->nullable();
            $table->string('typeDiscount')->nullable();
            $table->enum('paymentType', ['counted', 'credit']);
            $table->enum('type_transaction', ['sales', 'purchases']);
            $table->double('subtotal');
            $table->double('igv');
            $table->double('total');
            $table->text('observations')->nullable();
            defaultColumnsHelper::defaultColumns($table);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('vouchers');
    }
};
