<?php

use App\Helpers\defaultColumnsHelper;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('voucher_detail', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('voucher_id');
            $table->foreign('voucher_id')->references('id')->on('vouchers');
            $table->string('type');
            $table->unsignedBigInteger('product_id');
            $table->foreign('product_id')->references('id')->on('products');
            $table->double('cost')->nullable();
            $table->double('priceWithoutTax');
            $table->double('priceWithTax');
            $table->double('subtotal');
            $table->double('total');
            $table->double('quantity');
            $table->string('igv');
            $table->unsignedBigInteger('unit_of_measure_id');
            $table->foreign('unit_of_measure_id')->references('id')->on('unit_of_measure');
            defaultColumnsHelper::defaultColumns($table);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('voucher_detail');
    }
};
