<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use App\Helpers\defaultColumnsHelper;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('statement_of_accounts', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('person_id')->comment('client or provider');
            $table->foreign('person_id')->references('id')->on('people');
            $table->unsignedBigInteger('voucher_id');
            $table->foreign('voucher_id')->references('id')->on('vouchers');
            $table->enum('type_transaction', ['sales', 'purchases']);
            $table->double('total');
            $table->date('issue_date');
            $table->double('payment_status')->default(0)->comment('0: pending, 1: paid');
            defaultColumnsHelper::defaultColumns($table);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('statement_of_accounts');
    }
};
