<?php

namespace Database\Seeders;

// use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class DatabaseSeeder extends Seeder
{
    /**
     * Seed the application's database.
     */
    public function run(): void
    {
        $seeders = [
            CurrencySeeder::class,
            DocTypeSeeder::class,
            personTypeSeeder::class,
            UbigeoSeeder::class,
            unitOfMeasureSeeder::class,
            VoucherTypeSeeder::class,
            SerieSeeder::class
        ];

        if(!app()->environment('production')) {
            array_push(
             $seeders,
            ClientCategorySeeder::class,
                    establishmentSeeder::class,
                    PersonSeeder::class,
                    ProductBrandSeeder::class,
                    ProductCategorySeeder::class,
                    warehouseSeeder::class,
                    ProductSeeder::class,
                    roleSeeder::class,
            );
        }

        $this->call($seeders);
    }
}
