<?php

namespace Database\Seeders;

use App\Models\ClientCategory;
use App\Models\Person;
use App\Models\personType;
use App\Models\PersonTypeDetail;
use App\Models\CreditLine;
use App\Models\PersonPhone;
use Illuminate\Database\Seeder;

class PersonSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        Person::factory()->count(50)->create()->each(function ($person) {
            $personType = personType::all()->random()->id;
            PersonTypeDetail::create([
                'person_id' => $person->id,
                'person_type_id' => $personType,
            ]);

            PersonPhone::create([
                'person_id' => $person->id,
                'phone' => '+1 ' . rand(600000000, 699999999)
            ]);

            if ($personType === 1) {
                $person->client_category_id = ClientCategory::all()->random()->id;
                $person->save();
                $randomAmount = rand(500, 9000);
                CreditLine::create([
                    'person_id' => $person->id,
                    'total' => $randomAmount,
                    'used' => 0,
                    'residue' => $randomAmount,
                ]);
            }
        });
    }
}
