<?php

namespace Database\Seeders;

use App\Models\Product;
use App\Models\ProductBrand;
use App\Models\ProductBrandDetail;
use App\Models\WarehouseDetail;
use App\Models\warehouse;
use App\Models\Kardex;
use App\Models\InventoryDetail;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class ProductSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        Product::factory()->count(50)->create()->each(function ($product) {
            $brand = ProductBrand::all()->random()->id;
            $warehouse = warehouse::all()->random()->id;

            ProductBrandDetail::create([
                'product_id' => $product->id,
                'product_brand_id' => $brand,
            ]);

            $stock = fake()->numberBetween(1, 20);
            $warehouseDetail = WarehouseDetail::create([
                'product_id' => $product->id,
                'warehouse_id' => $warehouse,
                'stock' => $stock
            ]);


            InventoryDetail::create([
                'inventory_id' => 1,
                'product_id' => $product->id,
                'cost' => $product->cost,
                'amount' => $stock,
            ]);

            Kardex::create([
                'warehouse_detail_id' => $warehouseDetail->id,
                'voucher_id' => null,
                'type' => 'initial_entry',
                'cost' => $product->cost,
                'price' => 0,
                'quantity' => $stock,
            ]);
        });
    }
}
