<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\warehouse;
use App\Models\Inventory;

class warehouseSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $warehouse = [
            ['name' => 'VILLA MARIA DEL TRIUNFO', 'description' => ' MZA. 46 LOTE. 4 A.H. CESAR VALLEJO LIMA - LIMA - VILLA MARIA DEL TRIUNFO', 'establishment_id' => '1', 'ubigeo' => '150143', 'status' => 1],
        ];
        warehouse::insert($warehouse);

        $warehouseIds = Warehouse::where('status', 1)->pluck('id');
        $inventories = [];
        foreach ($warehouseIds as $warehouseId) {
            $inventories[] = [
                'name' => 'Inventario Inicial',
                'description' => '',
                'warehouse_id' => $warehouseId,
                'status' => 1
            ];
        }
        Inventory::insert($inventories);

    }
}
