import './bootstrap';
import '../css/main.css';
import 'flowbite';

import {createApp, h} from 'vue';
import {createInertiaApp} from '@inertiajs/vue3';
import {resolvePageComponent} from 'laravel-vite-plugin/inertia-helpers';
import {ZiggyVue} from '../../vendor/tightenco/ziggy/dist/vue.m';
import {createPinia} from 'pinia';

import {library} from '@fortawesome/fontawesome-svg-core';
import {FontAwesomeIcon} from '@fortawesome/vue-fontawesome';
import {fas} from '@fortawesome/free-solid-svg-icons';
import {fab} from '@fortawesome/free-brands-svg-icons';
import {far} from '@fortawesome/free-regular-svg-icons';

import PrimeVue from 'primevue/config';
import Aura from '@primevue/themes/aura';
import ToastService from 'primevue/toastservice';

library.add(fas, fab, far);

const appName = 'ARASA';

const pinia = createPinia();

createInertiaApp({
    title: (title) => `${title} - ${appName}`,
    resolve: (name) => resolvePageComponent(`./Pages/${name}.vue`, import.meta.glob('./Pages/**/*.vue')),
    setup({el, App, props, plugin}) {
        const app = createApp({render: () => h(App, props)});
        app.component('font-awesome-icon', FontAwesomeIcon);
        return app
            .use(plugin)
            .use(pinia)
            .use(ZiggyVue).use(PrimeVue, {
                ripple: true,
                theme: {
                    preset: Aura
                },
                locale: {
                    dayNamesMin: ["D", "L", "M", "X", "J", "V", "S"],
                    dayNames: ["Domingo", "Lunes", "Martes", "Miercoles", "Jueves", "Viernes", "Sabado"],
                    monthNames: ["Enero", "Febrero", 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre'],

                }
            }).use(ToastService).mount(el);
    },
    progress: {
        color: '#4B5563',
    },
});
