import {
    mdiAccountCircle,
    mdiMonitor,
    mdiGithub,
    mdiLock,
    mdiAlertCircle,
    mdiSquareEditOutline,
    mdiTable,
    mdiTelevisionGuide,
    mdiResponsive,
    mdiPalette,
    mdiInvoice,
    mdiCubeOutline,
    mdiFileDocument,
    mdiTextBox,
    mdiCash,
    mdiCashMarker,
} from '@mdi/js';

export default [
    {
        route: 'dashboard',
        icon: mdiMonitor,
        label: 'Dashboard'
    },
    {
        route: 'people.index',
        label: 'Personas',
        icon: mdiTable
    },
    {
        route: 'products.index',
        label: 'Productos',
        icon: mdiSquareEditOutline
    },
    {
        route: 'products_category.index',
        label: 'Categoria de productos',
        icon: mdiCubeOutline
    },
    {
        label: 'Stock Almacen',
        icon: mdiTelevisionGuide,
        menu: [
            {
                route: 'warehouse_detail.index',
                label: 'Almacen',
                icon: mdiCubeOutline
            },
            {
                route: 'kardex.index',
                label: 'Kardex',
                icon: mdiInvoice
            },
            {
                route: 'inventory.index',
                label: 'Inventario',
                icon: mdiAccountCircle
            },
        ]
    },
    {
        label: 'Ventas',
        icon: mdiTelevisionGuide,
        menu: [
            {
                route: 'sales.budgets.index',
                label: 'Cotizaciones',
                icon: mdiFileDocument
            },
            {
                route: 'sales.invoices.index',
                label: 'Facturas',
                icon: mdiInvoice
            },
            {
                route: 'sales.tickets.index',
                label: 'Boletas',
                icon: mdiTextBox
            },
        ]
    },
    {
        label: 'Compras',
        icon: mdiResponsive,
        menu: [
            {
                route: 'purchases.budgets.index',
                label: 'Cotizaciones',
                icon: mdiFileDocument
            },
            {
                route: 'purchases.invoices.index',
                label: 'Facturas',
                icon: mdiInvoice
            },
            {
                route: 'purchases.tickets.index',
                label: 'Boletas',
                icon: mdiTextBox
            },
        ]
    },
    {
        label: 'Tesoreria',
        icon: mdiCashMarker,
        menu: [
            {
                route: 'CollectCashFlow.statement_of_accounts.index',
                label: 'Cuentas por Cobrar',
                icon: mdiCash
            },
            {
                route: 'PayCashFlow.statement_of_accounts.index',
                label: 'Cuentas por Pagar',
                icon: mdiCash
            },
        ]
    },
    {
        route: '',
        label: 'Gastos',
        icon: mdiPalette
    },
    {
        label: 'Reportes',
        icon: mdiFileDocument,
        menu: [
            {
                route: 'report.reportCustomerLastSales',
                label: 'Clientes Ultima Compra',
                icon: mdiFileDocument
            },
            {
                route: 'report.reportCustomerSales',
                label: 'Ventas por Cliente',
                icon: mdiFileDocument
            },
            {
                route: 'report.reportProductSales',
                label: 'Ventas por Familia/Producto',
                icon: mdiFileDocument
            },
            {
                route: 'report.reportZoneSales',
                label: 'Ventas por Zona',
                icon: mdiFileDocument
            },
            {
                route: 'report.reportProviderPurchases',
                label: 'Compras por Proveedor',
                icon: mdiFileDocument
            },
            {
                route: 'report.reportSellerProfitSales',
                label: 'Vendedor y % de ganancia por ventas',
                icon: mdiFileDocument
            },
        ]
    },
    {
        label: 'Configuracion',
        icon: mdiAlertCircle,
        menu: [
            {
                route: 'role.index',
                label: 'Roles',
                icon: mdiAccountCircle
            },
            {
                route: 'warehouse.index',
                label: 'Almacenes',
                icon: mdiAccountCircle
            },
            {
                route: 'cost.index',
                label: 'Costos',
                icon: mdiCash
            },
        ]
    },
];
