import axios from "axios";

export default {
    downloadFile({ url, request, defaultFileName = null, fileType }) {
        return axios
            .post(url, request, {
                responseType: "arraybuffer",
            })
            .then((response) => {
                try {
                    let filename = "";
                    if (defaultFileName) {
                        filename = defaultFileName;
                    } else {
                        const disposition =
                            response.headers["content-disposition"];
                        if (
                            disposition &&
                            disposition.indexOf("attachment") !== -1
                        ) {
                            const filenameRegex =
                                /filename[^;=\n]*=((['"]).*?\2|[^;\n]*)/;
                            const matches = filenameRegex.exec(disposition);
                            if (matches != null && matches[1]) {
                                filename = matches[1].replace(/['"]/g, "");
                            }
                        }
                    }

                    let blob = new Blob([response.data], { type: fileType });
                    let link = document.createElement("a");
                    link.href = window.URL.createObjectURL(blob);
                    link.download = filename;
                    link.click();

                    return Promise.resolve("Downloaded file successfully.");
                } catch (error) {
                    return Promise.reject(error);
                }
            })
            .catch((error) => {
                return Promise.reject(
                    JSON.parse(
                        String.fromCharCode.apply(
                            null,
                            new Uint8Array(error.response.data)
                        )
                    )
                );
            });
    },

    post({ url, request }) {
        return axios.post(url, request).then(
            (response) => {
                return Promise.resolve(response);
            },
            (error) => {
                return Promise.reject(error);
            }
        );
    },
};
