<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <style>
        @page :first {
            margin: 0;
            padding: 0;
        }

        @page {
            margin: 0;
            padding: 0;
        }

        .m-0 {
            margin: 0 !important;
        }

        body {
            padding: 30px;
            font-size: 11px;
            font-family: Arial, Helvetica, sans-serif;
        }

        .text-center {
            text-align: center;
        }

        .text-justify {
            text-align: justify;
        }

        .w-100 {
            width: 100%;
        }

        .page_break {
            page-break-before: always;
        }

        .border {
            border: 1px solid;
        }

        #footer {
            text-align: right;
            position: fixed;
            left: 0;
            right: 70px;
            color: black;
            font-size: 10px;
            bottom: 50px;
        }

        .logo {
            width: 150px
        }

        .page-number:before {
            content: counter(page);
        }

        .text-uppercase {
            text-transform: uppercase;
        }

        .table {
            border-collapse: collapse;
            border: 1px solid;
        }

        .table tr {
            border-top: 1px solid;
            border-left: 1px solid;
            border-right: 1px solid;
        }

        .table td {
            border-left: 1px solid;
            border-right: 1px solid;
            padding: 0.5em;
        }

        .vertical-align-top {
            vertical-align: top;
        }

        .tr-header {
            font-weight: bold;
            color: black;
            background-color: orangered;
            text-transform: uppercase !important;
        }

        .right {
            text-align: right !important;
            padding-right: 15px !important;
        }

        .cotizacion-title {
            border: 1px solid black !important;
        }

        .font-bold {
            font-weight: bold !important;
        }

        .text-center {
            text-align: center;
        }
    </style>
</head>

<body>
    <table class="w-100">
        <tr>
            <td width="25%">
                <img class="logo" src="{{ 'storage/logo.svg' }}" />
            </td>
            <td width="45%">
                <div class="font-bold text-center">
                    <p class="h2 m-0">ARASA IMPORT S.A.C.</p>
                    <p class="m-0"> MZA. 46 LOTE. 4 A.H. CESAR VALLEJO </p>
                    <p class="m-0">LIMA - LIMA - VILLA MARIA DEL TRIUNFO - Peru</p>
                    <p class="m-0 text-uppercase">administracion@arasa-import.com</p>
                </div>
            </td>
            <td width="30%">
                <div class="cotizacion-title font-bold text-center">
                    <p>
                        R.U.C. 20611183225
                    </p>
                    <p>
                        COTIZACION
                    </p>
                    <p>
                        N° {{ $budget->number }}
                    </p>
                </div>
            </td>
        </tr>
    </table>

    <div class="w-100">

        <table class="w-100">
            <tr>
                <td width="80%">
                    <p>
                        <label class="font-bold"> Razon Social :</label>
                        <span class="text-uppercase">{{ $budget->person->legal_name }}</span>
                    </p>
                    <p><label class="font-bold">Teléfono     :</label> <span>{{ $budget->person->phone }}</span></p>
                    <p><label class="font-bold">Dirección     :</label> <span class="text-uppercase">{{ $budget->person->direction }}
                            @if ($budget->person->district)
                                {{ $budget->person->district->name }}
                                {{ $budget->person->district->province->name }}
                                {{ $budget->person->district->province->department->name }}
                            @endif
                        </span></p>
                    {{--<p><label class="font-bold">Almacén      :</label> <span>{{ $budget->warehouse->name }} -
                            {{ $budget->warehouse->establishment->name }}</span></p>--}}
                </td>
                <td witdh="20%" class="vertical-align-top">
                    <p><label class="font-bold">{{ $budget->person->doctype->description }}:</label> {{ $budget->person->document_number }}</p>
                    <p><label class="font-bold">Fecha:</label> {{ (new DateTime($budget->issue_date))->format('d/m/Y') }}</p>
                    {{--<p>Email: {{ $budget->client->email }}</p>--}}
                </td>
            </tr>
        </table>

        <table class="table w-100">
            <thead>
                <tr class="text-center tr-header">
                    <td width="3%"> Ítems
                    </td>
                    <td width="5%"> Cant.
                    </td>
                    <td width="8%"> Unid. Med
                    </td>
                    <td width="50%"> Descripción
                    </td>
                    <td width="10%"> Precio
                        Uni.
                        S/IGV
                    </td>
                    <td width="10%"> Sub Total
                    </td>
                    <td width="12%"> Venta Total
                    </td>
                </tr>
            </thead>
            <tbody>
                @foreach ($budget->details as $d)
                    <tr>
                        <td width="3%" class="text-center">
                            {{ $loop->index + 1 }}
                        </td>
                        <td width="5%" class="text-center">
                            {{ $d->quantity }}
                        </td>
                        <td width="8%" class="text-center">
                            {{ $d->product->unitOfMeasure->description }}
                        </td>
                        <td width="50%">
                            {{ $d->product->name }}
                        </td>
                        <td width="10%" class="right pr-1">
                            {{ number_format((float) $d->priceWithoutTax, 2, '.', '') }}
                        </td>
                        <td width="10%" class="right pr-1">
                            {{ number_format((float) $d->subtotal, 2, '.', '') }}
                        </td>
                        <td width="12%" class="right pr-1">
                            {{ number_format((float) $d->total, 2, '.', '') }}
                        </td>
                    </tr>
                @endforeach
            </tbody>
        </table>
        <br>
        <table class="w-100">
            <tr>
                <td style="width: 70%;" class="py-0">SON : {{ $textAmount }}</td>
                <td style="width: 15%;" class="py-0">IMPORTE BRUTO</td>
                <td style="padding-right: 0.3rem; width: 15%;" class="py-0 right">
                    {{ $budget->currency->symbol }}
                    {{ number_format((float) ($budget->subtotal + $budget->discounts), 2, '.', '') }}
                </td>
            </tr>
            <tr style="padding: 0;">
                <td style="width: 70%;" class="py-0"></td>
                <td style="width: 15%;" class="py-0">IMPUESTO</td>
                <td style="padding-right: 0.3rem; width: 15%;" class="py-0 right">
                    {{ $budget->currency->symbol }}
                    {{ number_format((float) $budget->igv, 2, '.', '') }}
                </td>
            </tr>
            <tr style="padding: 0;">
                <td style="width: 70%;" class="py-0"></td>
                <td style="width: 15%;" class="py-0">TOTAL</td>
                <td style="padding-right: 0.3rem; width: 15%;" class="py-0 right">
                    {{ $budget->currency->symbol }}
                    {{ number_format((float) $budget->total, 2, '.', '') }}
                </td>
            </tr>
        </table>

        <div class="w-full">
            <p class="font-bold">CONDICIONES DE VENTA</p>
            <table style="width: 100%; border-collapse: collapse;">
                <tr>
                    <td style="padding: 0; width: 10%;">Moneda</td>
                    <td style="padding: 0; width: 1%;">:</td>
                    <td style="padding-left: 0.5rem; width: 65%; text-transform: uppercase;">{{ $budget->currency->description }}</td>
                </tr>
                <tr>
                    <td style="padding: 0; width: 10%;">Documento</td>
                    <td style="padding: 0; width: 1%;">:</td>
                    <td style="padding-left: 0.5rem; width: 65%; text-transform: uppercase;">{{ $budget->voucher_type->name }}</td>
                </tr>
                <tr>
                    <td style="padding: 0; width: 10%;">BCP</td>
                    <td style="padding: 0; width: 1%;">:</td>
                    <td style="padding-left: 0.5rem; width: 65%; text-transform: uppercase;">1919972510022</td>
                </tr>
                <tr>
                    <td style="padding: 0; width: 10%;">Observacion</td>
                    <td style="padding: 0; width: 1%;">:</td>
                    <td style="padding-left: 0.5rem; width: 65%; text-transform: uppercase;">{{ $budget->observations }}</td>
                </tr>
            </table>
        </div>
    </div>
    <div id="footer">
        <div class="page-number"></div>
    </div>
</body>

</html>
