<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <style>
        @page :first {
            margin: 0;
            padding: 0;
        }

        @page {
            margin: 0;
            padding: 0;
        }

        .h1 {
            font-size: 2em;
            margin: 0 !important;
        }

        .h2 {
            font-size: 1.5em;
            margin: 0 !important;
        }

        .h3 {
            font-size: 1.17em;
            margin: 0 !important;
        }

        .h4 {
            font-size: 1em;
            margin: 0 !important;
        }

        .h5 {
            font-size: .83em;
            margin: 0 !important;
        }

        .m-0 {
            margin: 0 !important;
        }

        body {
            padding: 30px;
            font-size: 14px;
            font-family: Arial, Helvetica, sans-serif;
        }

        .text-center {
            text-align: center;
        }

        .text-justify {
            text-align: justify;
        }

        .w-100 {
            width: 100%;
        }

        .text-secondary {
            color: #404342;
        }

        .page_break {
            page-break-before: always;
        }

        .ml-4 {
            margin-left: 1.5rem !important;
        }

        .mt-3 {
            margin-top: 1rem !important;
        }

        .mt-5 {
            margin-top: 3rem !important;
        }

        .pt-4 {
            padding-top: 1.5rem !important;
        }

        .mx-2 {
            margin-left: 0.5rem !important;
            margin-right: 0.5rem !important;
        }

        .border {
            border: 1px solid;
        }

        .p-2 {
            padding: 0.5rem !important;
        }

        #footer {
            text-align: right;
            position: fixed;
            left: 0;
            right: 70px;
            color: black;
            font-size: 20px;
            bottom: 70px;
        }

        .logo {
            width: 150px
        }

        .page-number:before {
            content: counter(page);
        }

        .text-uppercase {
            text-transform: uppercase;
        }

        .table {
            border-collapse: collapse;
            border: 1px solid;
        }

        .table tr {
            border-top: 1px solid;
            border-left: 1px solid;
            border-right: 1px solid;
        }

        .table td {
            border-left: 1px solid;
            border-right: 1px solid;
        }

        .vertical-align-top {
            vertical-align: top;
        }
    </style>
</head>

<body>
    <table class="w-100">
        <tr>
            <td width="30%">
                <img class="logo" src="{{ 'storage/logo.svg' }}" />
            </td>
            <td width="70%">
                <p class="h2 m-0">ARASA</p>
                <p class="m-0">Principal: Calle Los Algarrobos 209 urb. Los Jardines</p>
                <p class="m-0">Lima, Lima - Peru</p>
                <p class="m-0">E-mail: ventas@arasa.com</p>
            </td>
        </tr>
    </table>

    <div class="w-100">
        <p class="text-center h1">{{$voucher->voucher_type->name}} {{ $voucher->number }}</p>

        <table class="w-100">
            <tr>
                <td width="60%">
                    <p>@if ($voucher->type_transaction === 'sales')
                        Señor(a):
                    @else
                        Proveedor(a):
                    @endif <span class="text-uppercase">{{ $voucher->person->legal_name }}</span></p>
                    <p>Dirección: <span class="text-uppercase">{{ $voucher->person->direction }} @if ($voucher->person->district)
                                {{ $voucher->person->district->name }}
                                {{ $voucher->person->district->province->name }}
                                {{ $voucher->person->district->province->department->name }}
                            @endif
                        </span></p>
                    <p>Teléfono: <span>{{ $voucher->person->phone }}</span></p>
                    <p>Almacén: <span>{{ $voucher->warehouse->name }} -
                            {{ $voucher->warehouse->establishment->name }}</span></p>
                </td>
                <td witdh="40%" class="vertical-align-top">
                    <p>{{ $voucher->person->doctype->description }}: {{ $voucher->person->document_number }}</p>
                    <p>Fecha: {{ (new DateTime($voucher->issue_date))->format('d-m-Y') }}</p>
                    <p>Email: {{ $voucher->person->email }}</p>
                </td>
            </tr>
        </table>

        <table class="table w-100">
            <thead>
                <tr>
                    <td width="5%"> Ítem
                    </td>
                    <td width="10%"> Código
                    </td>
                    <td width="30%"> Descripción
                    </td>
                    <td width="11%"> Uni.
                    </td>
                    <td width="5%"> Cant.
                    </td>
                    <td width="13%"> Precio
                        Uni.
                        S/IGV
                    </td>
                    <td width="13%"> Sub Total
                    </td>
                    <td width="13%"> Valor de Venta
                    </td>
                </tr>
            </thead>
            <tbody>
                @foreach ($voucher->details as $d)
                    <tr>
                        <td width="5%">
                            {{ $loop->index + 1 }}
                        </td>
                        <td width="10%">
                            {{ $d->product->code }}
                        </td>
                        <td width="30%">
                            {{ $d->product->name }}
                        </td>
                        <td width="11%">
                            {{ $d->product->unitOfMeasure->description }}
                        </td>
                        <td width="5%">
                            {{ $d->quantity }}
                        </td>
                        <td width="13%">
                            {{ number_format((float) $d->priceWithoutTax, 2, '.', '') }}
                        </td>
                        <td width="13%">
                            {{ number_format((float) $d->subtotal, 2, '.', '') }}
                        </td>
                        <td width="13%">
                            {{ number_format((float) $d->total, 2, '.', '') }}
                        </td>
                    </tr>
                @endforeach
            </tbody>
        </table>

        <br>
        <table class="w-100">
            <tr>
                <td width="70%" class="vertical-align-top">SON : {{ $textAmount }}</td>
                <td width="30%" class="vertical-align-top">
                    <p>IMPORTE BRUTO {{ number_format((float) ($voucher->subtotal + $voucher->discounts), 2, '.', '') }}
                    </p>
                    <p>DESCUENTO {{ number_format((float) $voucher->discounts, 2, '.', '') }}</p>
                    <p>VALOR DE VENTA {{ number_format((float) $voucher->subtotal, 2, '.', '') }}</p>
                    <p>IMPUESTO {{ number_format((float) $voucher->igv, 2, '.', '') }}</p>
                    <p class="text-uppercase">TOTAL {{ $voucher->currency->description }}
                        {{ number_format((float) $voucher->total, 2, '.', '') }}</p>
                </td>
            </tr>
        </table>

        <div>
            <p>CONDICIONES DE VENTA:</p>
            <p>Moneda: <span class="text-uppercase">{{ $voucher->currency->description }}</span></p>
        </div>
    </div>

    <div id="footer">
        <div class="page-number"></div>
    </div>
</body>

</html>
