<?php

use Illuminate\Foundation\Application;
use Illuminate\Support\Facades\Route;
use Inertia\Inertia;
use App\Http\Controllers\PersonController;
use App\Http\Controllers\ProductController;
use App\Http\Controllers\ProductCategoryController;
use App\Http\Controllers\BudgetController;
use App\Http\Controllers\inventoryController;
use App\Http\Controllers\CatalogueController;
use App\Http\Controllers\UbigeoController;
use App\Http\Controllers\warehouseController;
use App\Http\Controllers\WarehouseDetailController;
use App\Http\Controllers\VoucherController;
use App\Http\Controllers\roleController;
use App\Http\Controllers\KardexController;
use App\Http\Controllers\StatementOfAccountController;
use App\Http\Controllers\transactionsController ;
use App\Http\Controllers\InventoryDetailController ;
use App\Http\Controllers\ReportController ;
use App\Http\Controllers\CostController ;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () {
    return redirect('/dashboard');
});

Route::middleware([
    'auth:sanctum',
    config('jetstream.auth_session'),
    'verified',
])->group(function () {
    Route::get('/dashboard', function () {
        return Inertia::render('Dashboard');
    })->name('dashboard');

    Route::apiResource('people', PersonController::class);
    Route::apiResource('products', ProductController::class);
    Route::apiResource('products_category', ProductCategoryController::class);
    Route::apiResource('warehouse_detail', WarehouseDetailController::class);
    Route::apiResource('kardex', KardexController::class);

    Route::prefix('sales')->name('sales.')->middleware('AddSalesTransactionMiddleware')->group(function () {
        Route::get('/budgets', [BudgetController::class, 'index'])->name('budgets.index');
        Route::get('/budgets/create', [BudgetController::class, 'create'])->name('budgets.create');
        Route::get('/invoices', [VoucherController::class, 'index'])->name('invoices.index')->middleware('AddInvoiceVoucherTypeMiddleware');
        Route::get('/invoices/create', [VoucherController::class, 'create'])->name('invoices.create')->middleware('AddInvoiceVoucherTypeMiddleware');
        Route::get('/tickets', [VoucherController::class, 'index'])->name('tickets.index')->middleware('AddTicketVoucherTypeMiddleware');
        Route::get('/tickets/create', [VoucherController::class, 'create'])->name('tickets.create')->middleware('AddTicketVoucherTypeMiddleware');
    });

    Route::prefix('purchases')->name('purchases.')->middleware('AddPurchasesTransactionMiddleware')->group(function () {
        Route::get('/budgets', [BudgetController::class, 'index'])->name('budgets.index');
        Route::get('/budgets/create', [BudgetController::class, 'create'])->name('budgets.create');
        Route::get('/invoices', [VoucherController::class, 'index'])->name('invoices.index')->middleware('AddInvoiceVoucherTypeMiddleware');
        Route::get('/invoices/create', [VoucherController::class, 'create'])->name('invoices.create')->middleware('AddInvoiceVoucherTypeMiddleware');
        Route::get('/tickets', [VoucherController::class, 'index'])->name('tickets.index')->middleware('AddTicketVoucherTypeMiddleware');
        Route::get('/tickets/create', [VoucherController::class, 'create'])->name('tickets.create')->middleware('AddTicketVoucherTypeMiddleware');
    });

    Route::get('/budgets/{budget}/edit', [BudgetController::class, 'edit'])->name('budgets.edit');
    Route::post('/budgets', [BudgetController::class, 'store'])->name('budgets.store');
    Route::put('/budgets/{budget}', [BudgetController::class, 'update'])->name('budgets.update');
    Route::delete('/budgets/{budget}', [BudgetController::class, 'destroy'])->name('budgets.destroy');
    Route::put('/budgets/approve/{budget}', [BudgetController::class, 'approve'])->name('budgets.approve');
    Route::post('/budgets/downloadPDF', [BudgetController::class, 'downloadPDF'])->name('budgets.downloadPDF');
    Route::get('/budgets/downloadNewPDF/{budget}', [BudgetController::class, 'downloadNewPDF'])->name('budgets.downloadNewPDF');
    Route::get('/budgets/downloadNewEXCEL', [BudgetController::class, 'downloadNewEXCEL'])->name('budgets.downloadNewEXCEL');
    Route::post('/budgets/sendPDFtoEmail', [BudgetController::class, 'sendPDFtoEmail'])->name('budgets.sendPDFtoEmail');
    Route::get('/budgets/createVoucher/{budget}', [BudgetController::class, 'createVoucher'])->name('budgets.createVoucher');

    Route::get('/vouchers/{voucher}/edit', [VoucherController::class, 'edit'])->name('vouchers.edit');
    Route::post('/vouchers', [VoucherController::class, 'store'])->name('vouchers.store');
    Route::put('/vouchers/{voucher}', [VoucherController::class, 'update'])->name('vouchers.update');
    Route::delete('/vouchers/{voucher}', [VoucherController::class, 'destroy'])->name('vouchers.destroy');
    Route::post('/vouchers/downloadPDF', [VoucherController::class, 'downloadPDF'])->name('vouchers.downloadPDF');
    Route::post('/vouchers/sendPDFtoEmail', [VoucherController::class, 'sendPDFtoEmail'])->name('vouchers.sendPDFtoEmail');

    Route::apiResource('inventory', inventoryController::class);
    Route::apiResource('inventory_detail', InventoryDetailController::class);
    Route::apiResource('warehouse', warehouseController::class);
    Route::apiResource('budget', BudgetController::class);
    Route::apiResource('role', roleController::class);
    Route::apiResource('report', ReportController::class);
    Route::apiResource('cost', CostController::class);

    Route::get('/doc_types', [CatalogueController::class, 'getDocTypes'])->name('getDocTypes');
    Route::get('/person_types', [CatalogueController::class, 'getPersonTypes'])->name('getPersonTypes');
    Route::get('/clients_category', [CatalogueController::class, 'getClientsCategory'])->name('getClientsCategory');
    Route::get('/units_of_measure', [CatalogueController::class, 'getUnitsOfMeasure'])->name('getUnitsOfMeasure');
    Route::get('/product_categories', [CatalogueController::class, 'getProductCategories'])->name('getProductCategories');
    Route::get('/product_brands', [CatalogueController::class, 'getProductBrands'])->name('getProductBrands');
    Route::get('/currencies', [CatalogueController::class, 'getCurrencies'])->name('getCurrencies');
    Route::get('/departments', [UbigeoController::class, 'getDepartments'])->name('getDepartments');
    Route::get('/provinces/{id}', [UbigeoController::class, 'getProvinceByDepartmentId'])->name('getProvinces');
    Route::get('/districts/{id}', [UbigeoController::class, 'getDistrictByProvinceId'])->name('getDistricts');
    Route::get('/clientsByName', [CatalogueController::class, 'getClientsByName'])->name('getClientsByName');
    Route::get('/providersByName', [CatalogueController::class, 'getProvidersByName'])->name('getProvidersByName');
    Route::get('/productsByName', [CatalogueController::class, 'getProductsByName'])->name('getProductsByName');
    Route::get('/kardexProduct', [KardexController::class, 'getKardex'])->name('getKardex');
    Route::get('/warehousesByName', [CatalogueController::class, 'getWarehousesByName'])->name('getWarehousesByName');
    Route::get('/warehouseByName', [warehouseController::class, 'getWarehouseByName'])->name('getWarehouseByName');
    Route::get('/stablishmentByName', [warehouseController::class, 'getStablishmentByName'])->name('getStablishmentByName');
    Route::get('/budgetsByName', [VoucherController::class, 'getbudgetsByName'])->name('getbudgetsByName');
    Route::get('/roleByName', [VoucherController::class, 'getRoleByName'])->name('getRoleByName');
    Route::get('/roles', [CatalogueController::class, 'getRoles'])->name('getRoles');
    Route::get('/peopleRoleByName', [CatalogueController::class, 'getpeopleRoleByName'])->name('getpeopleRoleByName');

    Route::post('/people/downloadCustomers', [PersonController::class, 'downloadCustomers'])->name('people.downloadCustomers');

    Route::apiResource('statement_of_account', StatementOfAccountController::class);

    Route::prefix('PayCashFlow')->name('PayCashFlow.')->middleware('PayCashFlowMiddleware')->group(function () {
        Route::get('/statement_of_accounts', [StatementOfAccountController::class, 'index'])->name('statement_of_accounts.index');
        Route::get('/statement_of_accounts/create', [StatementOfAccountController::class, 'create'])->name('statement_of_accounts.create');
        Route::get('/statement_of_account/person/{person_id}', [StatementOfAccountController::class, 'showByPerson'])->name('statement_of_account.showByPerson');
        Route::post('/statement_of_accounts', [StatementOfAccountController::class, 'store'])->name('statement_of_accounts.store');
        Route::get('/transactions/person/{person_id}', [transactionsController::class, 'showByPerson'])->name('transactions.showByPerson');
        Route::delete('/transactions/{transaction}', [transactionsController::class, 'destroy'])->name('transactions.destroy');
    });

    Route::prefix('CollectCashFlow')->name('CollectCashFlow.')->middleware('CollectCashFlowMiddleware')->group(function () {
        Route::get('/statement_of_accounts', [StatementOfAccountController::class, 'index'])->name('statement_of_accounts.index');
        Route::get('/statement_of_accounts/create', [StatementOfAccountController::class, 'create'])->name('statement_of_accounts.create');
        Route::get('/statement_of_account/person/{person_id}', [StatementOfAccountController::class, 'showByPerson'])->name('statement_of_account.showByPerson');
        Route::post('/statement_of_accounts', [StatementOfAccountController::class, 'store'])->name('statement_of_accounts.store');
        Route::get('/transactions/person/{person_id}', [transactionsController::class, 'showByPerson'])->name('transactions.showByPerson');
        Route::delete('/transactions/{transaction}', [transactionsController::class, 'destroy'])->name('transactions.destroy');
    });

    Route::get('/dashboardClients', [PersonController::class, 'getClientsLastMonth'])->name('getClientsLastMonth');
    Route::get('/dashboardVouchers', [VoucherController::class, 'getVouchersLastMonth'])->name('getVouchersLastMonth');
    Route::get('/dashboardBirthdays', [PersonController::class, 'getTodaysBirthdays'])->name('getTodaysBirthdays');


    Route::get('/reportCustomerLastSales', [ReportController::class, 'reportCustomerLastSales'])->name('report.reportCustomerLastSales');
    Route::post('/report/downloadCustomerLastSales', [ReportController::class, 'downloadCustomerLastSales'])->name('report.downloadCustomerLastSales');
    Route::get('/report/chartCustomerLastSales', [ReportController::class, 'chartCustomerLastSales'])->name('report.chartCustomerLastSales');

    Route::get('/reportCustomerSales', [ReportController::class, 'reportCustomerSales'])->name('report.reportCustomerSales');
    Route::post('/report/downloadCustomerSales', [ReportController::class, 'downloadCustomerSales'])->name('report.downloadCustomerSales');

    Route::get('/reportProductSales', [ReportController::class, 'reportProductSales'])->name('report.reportProductSales');
    Route::post('/report/downloadProductSales', [ReportController::class, 'downloadProductSales'])->name('report.downloadProductSales');

    Route::get('/reportZoneSales', [ReportController::class, 'reportZoneSales'])->name('report.reportZoneSales');
    Route::post('/report/downloadZoneSales', [ReportController::class, 'downloadZoneSales'])->name('report.downloadZoneSales');

    Route::get('/reportProviderPurchases', [ReportController::class, 'reportProviderPurchases'])->name('report.reportProviderPurchases');
    Route::post('/report/downloadProviderPurchases', [ReportController::class, 'downloadProviderPurchases'])->name('report.downloadProviderPurchases');

    Route::get('/reportSellerProfitSales', [ReportController::class, 'reportSellerProfitSales'])->name('report.reportSellerProfitSales');
    Route::post('/report/downloadSellerProfitSales', [ReportController::class, 'downloadSellerProfitSales'])->name('report.downloadSellerProfitSales');

    Route::put('/cots/{id}', [CostController::class, 'update'])->name('cost.update');
    Route::put('/costs/update-all', [CostController::class, 'updateAll'])->name('cost.updateAll');


});
