<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <style>
        @page :first {
            margin: 0;
            padding: 0;
        }

        @page {
            margin: 0;
            padding: 0;
        }

        .h1 {
            font-size: 2em;
            margin: 0 !important;
        }

        .h2 {
            font-size: 1.5em;
            margin: 0 !important;
        }

        .h3 {
            font-size: 1.17em;
            margin: 0 !important;
        }

        .h4 {
            font-size: 1em;
            margin: 0 !important;
        }

        .h5 {
            font-size: .83em;
            margin: 0 !important;
        }

        .m-0 {
            margin: 0 !important;
        }

        body {
            padding: 30px;
            font-size: 14px;
            font-family: Arial, Helvetica, sans-serif;
        }

        .text-center {
            text-align: center;
        }

        .text-justify {
            text-align: justify;
        }

        .w-100 {
            width: 100%;
        }

        .text-secondary {
            color: #404342;
        }

        .page_break {
            page-break-before: always;
        }

        .ml-4 {
            margin-left: 1.5rem !important;
        }

        .mt-3 {
            margin-top: 1rem !important;
        }

        .mt-5 {
            margin-top: 3rem !important;
        }

        .pt-4 {
            padding-top: 1.5rem !important;
        }

        .mx-2 {
            margin-left: 0.5rem !important;
            margin-right: 0.5rem !important;
        }

        .border {
            border: 1px solid;
        }

        .p-2 {
            padding: 0.5rem !important;
        }

        #footer {
            text-align: right;
            position: fixed;
            left: 0;
            right: 70px;
            color: black;
            font-size: 20px;
            bottom: 70px;
        }

        .logo {
            width: 150px
        }

        .page-number:before {
            content: counter(page);
        }

        .text-uppercase {
            text-transform: uppercase;
        }

        .table {
            border-collapse: collapse;
            border: 1px solid;
        }

        .table tr {
            border-top: 1px solid;
            border-left: 1px solid;
            border-right: 1px solid;
        }

        .table td {
            border-left: 1px solid;
            border-right: 1px solid;
        }

        .vertical-align-top {
            vertical-align: top;
        }
    </style>
</head>

<body>
    <table class="w-100">
        <tr>
            <td width="30%">
                <img class="logo" src="<?php echo e('storage/logo.svg'); ?>" />
            </td>
            <td width="70%">
                <p class="h2 m-0">ARASA</p>
                <p class="m-0">Principal: Calle Los Algarrobos 209 urb. Los Jardines</p>
                <p class="m-0">Lima, Lima - Peru</p>
                <p class="m-0">E-mail: ventas@arasa.com</p>
            </td>
        </tr>
    </table>

    <div class="w-100">
        <p class="text-center h1"><?php echo e($voucher->voucher_type->name); ?> <?php echo e($voucher->number); ?></p>

        <table class="w-100">
            <tr>
                <td width="60%">
                    <p><?php if($voucher->type_transaction === 'sales'): ?>
                        Señor(a):
                    <?php else: ?>
                        Proveedor(a):
                    <?php endif; ?> <span class="text-uppercase"><?php echo e($voucher->person->legal_name); ?></span></p>
                    <p>Dirección: <span class="text-uppercase"><?php echo e($voucher->person->direction); ?> <?php if($voucher->person->district): ?>
                                <?php echo e($voucher->person->district->name); ?>

                                <?php echo e($voucher->person->district->province->name); ?>

                                <?php echo e($voucher->person->district->province->department->name); ?>

                            <?php endif; ?>
                        </span></p>
                    <p>Teléfono: <span><?php echo e($voucher->person->phone); ?></span></p>
                    <p>Almacén: <span><?php echo e($voucher->warehouse->name); ?> -
                            <?php echo e($voucher->warehouse->establishment->name); ?></span></p>
                </td>
                <td witdh="40%" class="vertical-align-top">
                    <p><?php echo e($voucher->person->doctype->description); ?>: <?php echo e($voucher->person->document_number); ?></p>
                    <p>Fecha: <?php echo e((new DateTime($voucher->issue_date))->format('d-m-Y')); ?></p>
                    <p>Email: <?php echo e($voucher->person->email); ?></p>
                </td>
            </tr>
        </table>

        <table class="table w-100">
            <thead>
                <tr>
                    <td width="5%"> Ítem
                    </td>
                    <td width="10%"> Código
                    </td>
                    <td width="30%"> Descripción
                    </td>
                    <td width="11%"> Uni.
                    </td>
                    <td width="5%"> Cant.
                    </td>
                    <td width="13%"> Precio
                        Uni.
                        S/IGV
                    </td>
                    <td width="13%"> Sub Total
                    </td>
                    <td width="13%"> Valor de Venta
                    </td>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $voucher->details; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $d): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td width="5%">
                            <?php echo e($loop->index + 1); ?>

                        </td>
                        <td width="10%">
                            <?php echo e($d->product->code); ?>

                        </td>
                        <td width="30%">
                            <?php echo e($d->product->name); ?>

                        </td>
                        <td width="11%">
                            <?php echo e($d->product->unitOfMeasure->description); ?>

                        </td>
                        <td width="5%">
                            <?php echo e($d->quantity); ?>

                        </td>
                        <td width="13%">
                            <?php echo e(number_format((float) $d->priceWithoutTax, 2, '.', '')); ?>

                        </td>
                        <td width="13%">
                            <?php echo e(number_format((float) $d->subtotal, 2, '.', '')); ?>

                        </td>
                        <td width="13%">
                            <?php echo e(number_format((float) $d->total, 2, '.', '')); ?>

                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>

        <br>
        <table class="w-100">
            <tr>
                <td width="70%" class="vertical-align-top">SON : <?php echo e($textAmount); ?></td>
                <td width="30%" class="vertical-align-top">
                    <p>IMPORTE BRUTO <?php echo e(number_format((float) ($voucher->subtotal + $voucher->discounts), 2, '.', '')); ?>

                    </p>
                    <p>DESCUENTO <?php echo e(number_format((float) $voucher->discounts, 2, '.', '')); ?></p>
                    <p>VALOR DE VENTA <?php echo e(number_format((float) $voucher->subtotal, 2, '.', '')); ?></p>
                    <p>IMPUESTO <?php echo e(number_format((float) $voucher->igv, 2, '.', '')); ?></p>
                    <p class="text-uppercase">TOTAL <?php echo e($voucher->currency->description); ?>

                        <?php echo e(number_format((float) $voucher->total, 2, '.', '')); ?></p>
                </td>
            </tr>
        </table>

        <div>
            <p>CONDICIONES DE VENTA:</p>
            <p>Moneda: <span class="text-uppercase"><?php echo e($voucher->currency->description); ?></span></p>
        </div>
    </div>

    <div id="footer">
        <div class="page-number"></div>
    </div>
</body>

</html>
<?php /**PATH C:\laragon\www\arasa\resources\views/pdf/vouchers/voucher.blade.php ENDPATH**/ ?>